program simulation_program
		syntax, reps(str) name(str) regression(str) outcome(str) 

		clear matrix
		set more off
		forval i=1/`reps' { // # of times you simulate treatment and run regressions
		
		use bal_power_data, clear // load simulated dataset
		randomization // run randomization (program)
		merge m:1 divid using rand.dta, assert(3) nogen
		
		sum `outcome' if treatment==0 
		local control_mean =r(mean) // store control mean
		local control_sd =r(sd)  // store control SD
		
		`regression' // run main specification
		
		// the below matrix captures regression output as rows in a matrix  
		matrix table=r(table)
		matrix p=table["pvalue", "treatment"]
		matrix t=table["t", "treatment"]
		matrix `name'=nullmat(`name') \ ///
			(p[1,1], t[1,1], `control_mean', `control_sd', _b[treatment], ///
			_se[treatment], _b[treatment] - 1.96*_se[treatment], ///
			_b[treatment] + 1.96*_se[treatment])
		
		matrix colnames `name' = ///
			pvalue tstat control_mean control_sd beta se ci_low ci_high 
		}
		
		clear 
		svmat `name', names(col) // this loads matrix as variables
		count if pvalue<0.05 
		gen pvalue_sig=`r(N)'/_N // this counts % times beta coeff was significant at 5% level
		order pvalue_sig
		drop pvalue
		collapse * // this reports the average across all iterations (rows of the matrix)
		
		mkmat *, matrix(pwr_`name') // save as matrix
		clear
		// output new matrix to excel
		svmat2 pwr_`name', names(col) rnames(rows) 
		order rows, first
		export excel _all using "JPAL Power Exercises", firstrow(variables) ///
			cell(B2) sheetmodify sheet(`name')
end
